/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.synchronize;

import java.io.IOException;
import java.util.HashSet;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.synchronize.BaseSynchronize;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class SynchronizeVirtualFileSystems
extends BaseSynchronize {
    private static final int STATE_VERSION = 0;
    private IVirtualFileSystem input;
    private IVirtualFileSystem output;
    private ScePspDateTime lastSyncDate;

    public SynchronizeVirtualFileSystems(String name, IVirtualFileSystem input, IVirtualFileSystem output, Object lock) {
        super(name, lock);
        this.input = input;
        this.output = output;
        this.lastSyncDate = this.nowDate();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.lastSyncDate.read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.lastSyncDate.write(stream);
        super.write(stream);
    }

    @Override
    protected void invalidateCachedData() {
        if (this.input instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.input)).invalidateCachedData();
        }
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).invalidateCachedData();
        }
    }

    private void closeCachedFiles() {
        if (this.input instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.input)).closeCachedFiles();
        }
        if (this.output instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.output)).closeCachedFiles();
        }
    }

    @Override
    protected int deltaSynchronize() {
        this.invalidateCachedData();
        this.closeCachedFiles();
        ScePspDateTime newLastSync = this.nowDate();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("deltaSynchronize %s start", this.name));
        }
        int result = this.deltaSynchronize("");
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("deltaSynchronize %s end", this.name));
        }
        this.lastSyncDate = newLastSync;
        return result;
    }

    private boolean isModifiedSinceLastSync(SceIoDirent dirent) {
        if (dirent.stat.mtime.after(this.lastSyncDate)) {
            return true;
        }
        return dirent.stat.mtime.toMSDOSTime() == 0;
    }

    private boolean isDirectory(SceIoDirent entry) {
        return (entry.stat.attr & 0x10) != 0;
    }

    private boolean sameEntryNameAndAttributes(SceIoDirent dirent1, SceIoDirent dirent2) {
        if (dirent1 == null) {
            return dirent2 == null;
        }
        if (dirent2 == null) {
            return dirent1 == null;
        }
        if (!dirent1.filename.equalsIgnoreCase(dirent2.filename)) {
            return false;
        }
        if (dirent1.stat.attr != dirent2.stat.attr) {
            return false;
        }
        if (dirent1.stat.mode != dirent2.stat.mode) {
            return false;
        }
        return dirent1.stat.size == dirent2.stat.size;
    }

    private SceIoDirent[] getDirectoryEntries(IVirtualFileSystem vfs, String dirName) {
        String[] fileNames = vfs.ioDopen(dirName);
        SceIoDirent[] entries = new SceIoDirent[]{};
        if (fileNames != null) {
            for (String fileName : fileNames) {
                if (".".equals(fileName) || "..".equals(fileName)) continue;
                SceIoDirent entry = new SceIoDirent(new SceIoStat(), fileName);
                int result = vfs.ioDread(dirName, entry);
                if (result != 1) {
                    return null;
                }
                entries = Utilities.add(entries, entry);
            }
        }
        return entries;
    }

    private int deltaSynchronize(String dirName) {
        int result;
        int i;
        SceIoDirent[] inputEntries;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("deltaSynchronize '%s'", dirName));
        }
        if ((inputEntries = this.getDirectoryEntries(this.input, dirName)) == null) {
            return -1;
        }
        SceIoDirent[] outputEntries = this.getDirectoryEntries(this.output, dirName);
        if (outputEntries == null) {
            return -1;
        }
        HashSet<SceIoDirent> toBeUpdated = new HashSet<SceIoDirent>();
        HashSet<SceIoDirent> toBeCreated = new HashSet<SceIoDirent>();
        for (i = 0; i < inputEntries.length; ++i) {
            SceIoDirent inputEntry = inputEntries[i];
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("deltaSynchronize '%s', entry=%s", dirName, inputEntry));
            }
            boolean found = false;
            for (int j = 0; j < outputEntries.length; ++j) {
                if (!this.sameEntryNameAndAttributes(inputEntry, outputEntries[j])) continue;
                if (!this.isDirectory(inputEntry) && this.isModifiedSinceLastSync(inputEntry)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("deltaSynchronize: entry to be updated inputEntry=%s, lastSyncDate=%s", inputEntry, this.lastSyncDate));
                    }
                    toBeUpdated.add(inputEntry);
                }
                outputEntries[j] = null;
                found = true;
                break;
            }
            if (found) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("deltaSynchronize: entry to be created inputEntry=%s", inputEntry));
            }
            toBeCreated.add(inputEntry);
        }
        for (i = 0; i < outputEntries.length; ++i) {
            int result2;
            if (outputEntries[i] == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("deltaSynchronize: entry to be deleted outputEntry=%s", outputEntries[i]));
            }
            if ((result2 = this.deleteEntry(dirName, outputEntries[i])) == 0) continue;
            return result2;
        }
        for (SceIoDirent entry : toBeCreated) {
            result = this.createEntry(dirName, entry);
            if (result == 0) continue;
            return result;
        }
        for (SceIoDirent entry : toBeUpdated) {
            result = this.updateEntry(dirName, entry);
            if (result == 0) continue;
            return result;
        }
        for (int i2 = 0; i2 < inputEntries.length; ++i2) {
            if (!this.isDirectory(inputEntries[i2])) continue;
            String subDirName = inputEntries[i2].filename;
            if (dirName.length() > 0) {
                subDirName = dirName + '/' + subDirName;
            }
            if ((result = this.deltaSynchronize(subDirName)) == 0) continue;
            return result;
        }
        return 0;
    }

    private String getFileName(String dirName, SceIoDirent entry) {
        if (dirName.length() == 0) {
            return entry.filename;
        }
        return String.format("%s/%s", dirName, entry.filename);
    }

    private int updateEntry(String dirName, SceIoDirent entry) {
        int readLength;
        IVirtualFile inputFile;
        String fileName = this.getFileName(dirName, entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateEntry %s", fileName));
        }
        if ((inputFile = this.input.ioOpen(fileName, 1, 0)) == null) {
            log.error((Object)String.format("updateEntry cannot read file '%s'", fileName));
            return -1;
        }
        IVirtualFile outputFile = this.output.ioOpen(fileName, 2, 0);
        if (outputFile == null) {
            inputFile.ioClose();
            log.error((Object)String.format("updateEntry cannot write file '%s'", fileName));
            return -1;
        }
        byte[] buffer = new byte[32768];
        for (long inputLength = inputFile.length(); inputLength > 0L; inputLength -= (long)readLength) {
            int length = Math.min(buffer.length, (int)inputLength);
            readLength = inputFile.ioRead(buffer, 0, length);
            if (readLength != length) {
                log.error((Object)String.format("updateEntry error reading file '%s': 0x%X", fileName, readLength));
                return -1;
            }
            int writeLength = outputFile.ioWrite(buffer, 0, readLength);
            if (writeLength == readLength) continue;
            log.error((Object)String.format("updateEntry error writing file '%s': 0x%X", fileName, writeLength));
            return -1;
        }
        inputFile.ioClose();
        outputFile.ioClose();
        return 0;
    }

    private int createEntry(String dirName, SceIoDirent entry) {
        int result;
        if (this.isDirectory(entry)) {
            String fileName = this.getFileName(dirName, entry);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("createEntry %s", fileName));
            }
            if ((result = this.output.ioMkdir(fileName, 511)) != 0) {
                log.error((Object)String.format("createEntry could not create directory '%s'", fileName));
            }
        } else {
            result = this.updateEntry(dirName, entry);
        }
        return result;
    }

    private int deleteEntry(String dirName, SceIoDirent entry) {
        int result;
        String fileName = this.getFileName(dirName, entry);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("deleteEntry %s", fileName));
        }
        if (this.isDirectory(entry)) {
            result = this.deleteDirectoryEntryRecursive(fileName);
        } else {
            result = this.output.ioRemove(fileName);
            if (result != 0) {
                log.error((Object)String.format("deleteEntry could not delete '%s'", fileName));
            }
        }
        return result;
    }

    private int deleteDirectoryEntryRecursive(String dirName) {
        SceIoDirent[] entries = this.getDirectoryEntries(this.output, dirName);
        if (entries == null) {
            log.error((Object)String.format("deleteDirectoryEntryRecursive could not delete '%s'", dirName));
            return -1;
        }
        int result = 0;
        for (SceIoDirent entry : entries) {
            String fileName = this.getFileName(dirName, entry);
            if (this.isDirectory(entry)) {
                result = this.deleteDirectoryEntryRecursive(fileName);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("deleteDirectoryEntryRecursive: delete file %s", fileName));
                }
                if ((result = this.output.ioRemove(fileName)) != 0) {
                    log.error((Object)String.format("deleteDirectoryEntryRecursive could not delete '%s'", dirName));
                }
            }
            if (result == 0) continue;
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("deleteDirectoryEntryRecursive: delete directory %s", dirName));
        }
        if ((result = this.output.ioRmdir(dirName)) != 0) {
            log.error((Object)String.format("deleteDirectoryEntryRecursive could not delete '%s'", dirName));
        }
        return result;
    }
}

